//---------------------------------------------------------------------------
//A BCBuilder4 example to open two service requests concurrently so that two
//subsystems can be used on one board. The example was originally intended
//for use with the DAS-80x series.
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "DlsrLib_OCX"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
        // initialize a service request for the analog input subsystem
        aisr->Req_DLL_name="*.dll";
        // replace above "*.dll" with the name of your driver to
        // avoid the OpenDriverLINX dialog box
        // kmb800 = driver name for DAS-800
        // kpci3108 for KPCI-3108 or KPCI-3107
        // kpci3100 for KPCI-3101,2,3,4,-3116 or -3110
        // kpcaiao for PCMCIA
        // kmb1800 for DAS-1800
        aisr->Req_device=0;
        // change device number according to the value you used
        // in the DriverLINX Configuration Panel
        aisr->Req_op=DL_INITIALIZE;
        aisr->Req_subsystem=DL_DEVICE;
        aisr->Refresh();

        ResCode->Caption=aisr->Res_result;
        message->Caption=aisr->Message;
        aisr->Refresh();
        aisr->Req_op=DL_START;
        aisr->Req_mode=DL_POLLED;
        aisr->Req_subsystem=DL_AI;
        aisr->Sel_chan_N=1;      //specify start channel only
        aisr->Sel_chan_start=0;  //start on channel 0
        aisr->Sel_chan_startGainCode=aisr->DLGain2Code(-1);
        aisr->Sel_buf_N=0;       // polled mode, need no buffers
        aisr->Evt_Str_type=DL_COMMAND;   // start when Refresh is called
        aisr->Evt_Stp_type=DL_TCEVENT;   // stop when the # of samples are obtained
        aisr->Evt_Tim_type=DL_NULLEVENT; // polled mode, no pacing information
        aisr->Refresh();

        //initialize a service request for the digital I/O subsystem
        diosr->Req_DLL_name="*.dll";
        diosr->Req_device=0;
        diosr->Req_op=DL_INITIALIZE;
        diosr->Req_subsystem=DL_DEVICE;
        diosr->Refresh();
        //if your board has configurable digital channels your
        //digital channel 0 must be configured for output mode
        //for this example to work (KPCI-3101,2,3,4,-3116,-3110).
        diosr->Req_op=DL_START;
        diosr->Req_mode=DL_POLLED;
        diosr->Req_subsystem=DL_DO;
        diosr->Sel_chan_N=1;
        diosr->Sel_chan_start=0;
        diosr->Sel_chan_startGainCode=0;
        diosr->Sel_buf_samples=1;
        diosr->Sel_buf_N=0;
        diosr->Evt_Str_type=DL_NULLEVENT;
        diosr->Evt_Stp_type=DL_NULLEVENT;
        diosr->Evt_Tim_type=DL_NULLEVENT;
        diosr->Sel_buf_notify=DL_NOEVENTS;
        diosr->Refresh();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::sampleClick(TObject *Sender)
{
        //make a single analog input measurement
        aisr->Refresh();
        airesult->Caption=aisr->DLCode2Volts(aisr->Res_Sta_ioValue);
        // DLCode2Volts works only for default GainCodes of 0 which
        // corresponds to bipolar range and gain of 1.  Use ArrayBufferConvert
        // method for "gain aware" conversion.
        // the Res_Sta_ioValue property of the SR control can host the data
        // for a polled mode operation.  For multi-sample paced operations,
        // a buffer must be used to host the data.
        ResCode->Caption=aisr->Res_result;
        message->Caption=aisr->Message;
        aisr->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::exitClick(TObject *Sender)
{
        //close the driver nicely
        aisr->Req_DLL_name="";
        diosr->Req_DLL_name="";
        Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::dio_hiClick(TObject *Sender)
{
        //set the digital output ch0, bit0 to hi
        diosr->Res_Sta_ioValue=1;
        dioresult->Caption=diosr->Res_Sta_ioValue;
        diosr->Refresh();
        diorescode->Caption=diosr->Res_result;
        diomessage->Caption=diosr->Message;
        diosr->Refresh();

}
//---------------------------------------------------------------------------

void __fastcall TForm1::dio_loClick(TObject *Sender)
{
        //set the digital output ch0, bit0 to lo
        diosr->Res_Sta_ioValue=0;
        dioresult->Caption=diosr->Res_Sta_ioValue;
        diosr->Refresh();
        diorescode->Caption=diosr->Res_result;
        diomessage->Caption=diosr->Message;
        diosr->Refresh();

}
//---------------------------------------------------------------------------

